!function ($, $ele, $i) {
    window.liteTranslated = function (e, t) {
        return elementorCommon.translate(e, null, t, hostimEditor.i18n)
    };

    var $app = {
        Views: {},
        Models: {},
        Collections: {},
        Behaviors: {},
        Layout: null,
        Manager: null
    };
    $app.Models.Template = Backbone.Model.extend({
        defaults: {
            template_id: 0,
            title: "",
            type: "",
            thumbnail: "",
            url: "",
            liveurl: "",
            favorite: "",
            tags: [],
            isPro: !1
        }
    }), 
    $app.Collections.Template = Backbone.Collection.extend({
        model: $app.Models.Template
    }), 
    $app.Behaviors.InsertTemplate = Marionette.Behavior.extend({
        ui: {
            insertButton: ".liteTemplateLibrary_insert-button"
        },
        events: {
            "click @ui.insertButton": "onInsertButtonClick"
        },
        onInsertButtonClick: function() {
            $i.library.insertTemplate({
                model: this.view.model
            })
        }
    }), 
    $app.Views.EmptyTemplateCollection = Marionette.ItemView.extend({
        id: "elementor-template-library-templates-empty",
        template: "#hostim-liteTemplateLibrary_empty",
        ui: {
            title: ".elementor-template-library-blank-title",
            message: ".elementor-template-library-blank-message"
        },
        modesStrings: {
            empty: {
                title: liteTranslated("templatesEmptyTitle"),
                message: liteTranslated("templatesEmptyMessage")
            },
            noResults: {
                title: liteTranslated("templatesNoResultsTitle"),
                message: liteTranslated("templatesNoResultsMessage")
            }
        },
        getCurrentMode: function() {
            return $i.library.getFilter("text") ? "noResults" : "empty"
        },
        onRender: function() {
            var e = this.modesStrings[this.getCurrentMode()];
            this.ui.title.html(e.title), this.ui.message.html(e.message)
        }
    }), 
    $app.Views.Loading = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_loading",
        id: "liteTemplateLibrary_loading"
    }), 
    $app.Views.Logo = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_header-logo",
        className: "liteTemplateLibrary_header-logo",
        templateHelpers: function() {
            return {
                title: this.getOption("title")
            }
        }
    }), 
    $app.Views.BackButton = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_header-back",
        id: "elementor-template-library-header-preview-back",
        className: "liteTemplateLibrary_header-back",
        events: function() {
            return {
                click: "onClick"
            }
        },
        onClick: function() {
            $i.library.showTemplatesView()
        }
    }), 
    $app.Views.Menu = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_header-menu",
        id: "elementor-template-library-header-menu",
        className: "liteTemplateLibrary_header-menu",
        templateHelpers: function() {
            return $i.library.getTabs()
        },
        ui: {
            menuItem: ".elementor-template-library-menu-item"
        },
        events: {
            "click @ui.menuItem": "onMenuItemClick"
        },
        onMenuItemClick: function(e) {
            $i.library.setFilter("tags", ""), $i.library.setFilter("text", ""), $i.library.setFilter("type", e.currentTarget.dataset.tab, !0), $i.library.showTemplatesView()
        }
    }), 
    $app.Views.ResponsiveMenu = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_header-menu-responsive",
        id: "elementor-template-library-header-menu-responsive",
        className: "liteTemplateLibrary_header-menu-responsive",
        ui: {
            items: "> .elementor-component-tab"
        },
        events: {
            "click @ui.items": "onTabItemClick"
        },
        onTabItemClick: function(t) {
            var a = $(t.currentTarget),
                n = a.data("tab");
            $i.library.channels.tabs.trigger("change:device", n, a)
        }
    }), 
    $app.Views.Actions = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_header-actions",
        id: "elementor-template-library-header-actions",
        ui: {
            sync: "#liteTemplateLibrary_header-sync i"
        },
        events: {
            "click @ui.sync": "onSyncClick"
        },
        onSyncClick: function() {
            var e = this;
            e.ui.sync.addClass("eicon-animation-spin"), $i.library.requestLibraryData({
                onUpdate: function() {
                    e.ui.sync.removeClass("eicon-animation-spin"), $i.library.updateBlocksView()
                },
                forceUpdate: !0,
                forceSync: !0
            })
        }
    }), 
    $app.Views.InsertWrapper = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_header-insert",
        id: "elementor-template-library-header-preview",
        behaviors: {
            insertTemplate: {
                behaviorClass: $app.Behaviors.InsertTemplate
            }
        }
    }), 
    $app.Views.Preview = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_preview",
        className: "liteTemplateLibrary_preview",
        ui: function() {
            return {
                img: "> img"
            }
        },
        onRender: function() {
            this.ui.img.attr("src", this.getOption("url")).hide();
            var e = this,
                t = (new $app.Views.Loading).render();
            this.$el.append(t.el), this.ui.img.on("load", function() {
                e.$el.find("#liteTemplateLibrary_loading").remove(), e.ui.img.show()
            })
        }
    }), 
    $app.Views.TemplateCollection = Marionette.CompositeView.extend({
        template: "#hostim-liteTemplateLibrary_templates",
        id: "liteTemplateLibrary_templates",
        className: function() {
            return "liteTemplateLibrary_templates liteTemplateLibrary_templates--" + $i.library.getFilter("type")
        },
        childViewContainer: "#liteTemplateLibrary_templates-list",
        emptyView: function() {
            return new $app.Views.EmptyTemplateCollection
        },
        ui: {
            templatesWindow: ".liteTemplateLibrary_templates-window",
            textFilter: "#liteTemplateLibrary_search",
            tagsFilter: "#liteTemplateLibrary_filter-tags",
            filterBar: "#liteTemplateLibrary_toolbar-filter",
            counter: "#liteTemplateLibrary_toolbar-counter"
        },
        events: {
            "input @ui.textFilter": "onTextFilterInput",
            "click @ui.tagsFilter li": "onTagsFilterClick"
        },
        getChildView: function(e) {
            return $app.Views.Template
        },
        initialize: function() {
            this.listenTo($i.library.channels.templates, "filter:change", this._renderChildren)
        },
        filter: function(e) {
            var t = $i.library.getFilterTerms(),
                a = !0;
            return _.each(t, function(t, n) {
                var r = $i.library.getFilter(n);
                if (r && t.callback) {
                    var l = t.callback.call(e, r);
                    return l || (a = !1), l
                }
            }), a
        },
        setMasonrySkin: function() {
            
            if ('section' === $i.library.getFilter("type")) {
                var e = new elementorModules.utils.Masonry({
                    container: this.$childViewContainer,
                    items: this.$childViewContainer.children()
                });
                this.$childViewContainer.imagesLoaded(e.run.bind(e))
            }
        },
        onRenderCollection: function() {
            this.setMasonrySkin(), this.updatePerfectScrollbar(), this.setTemplatesFoundText()
        },
        setTemplatesFoundText: function() {
            var e = $i.library.getFilter("type"),
                t = this.children.length;
            text = "<strong>" + t + "</strong>", text += "section" === e ? " block" : " " + e, t > 1 && (text += "s"), text += " found", this.ui.counter.html(text)
        },
        onTextFilterInput: function() {
            var e = this;
            _.defer(function() {
                $i.library.setFilter("text", e.ui.textFilter.val())
            })
        },
        onTagsFilterClick: function(t) {
            var a = $(t.currentTarget),
                n = a.data("tag");
            $i.library.setFilter("tags", n), a.addClass("active").siblings().removeClass("active"), n = n ? $i.library.getTags()[n] : "Filter", this.ui.filterBar.find(".liteTemplateLibrary_filter-btn").html(n + ' <i class="eicon-caret-down"></i>')
        },
        updatePerfectScrollbar: function() {
            this.perfectScrollbar || (this.perfectScrollbar = new PerfectScrollbar(this.ui.templatesWindow[0], {
                suppressScrollX: !0
            })), this.perfectScrollbar.isRtl = !1, this.perfectScrollbar.update()
        },
        setTagsFilterHover: function() {
            var e = this;
            e.ui.filterBar.hoverIntent(function() {
                e.ui.tagsFilter.addClass("liteTemplateLibrary_filter-show"), e.ui.filterBar.find(".liteTemplateLibrary_filter-btn i").addClass("eicon-caret-down").removeClass("eicon-caret-right")
            }, function() {
                e.ui.tagsFilter.removeClass("liteTemplateLibrary_filter-show");
                e.ui.tagsFilter.addClass("liteTemplateLibrary_filter-hide"), e.ui.filterBar.find(".liteTemplateLibrary_filter-btn i").addClass("eicon-caret-right").removeClass("eicon-caret-down")
            }, {
                sensitivity: 50,
                interval: 150,
                timeout: 100
            })
        },
        onRender: function() {
            this.setTagsFilterHover(), this.updatePerfectScrollbar()
        }
    }), 
    $app.Views.Template = Marionette.ItemView.extend({
        template: "#hostim-liteTemplateLibrary_template",
        className: "liteTemplateLibrary_template",
        ui: {
            previewButton: ".liteTemplateLibrary_preview-button, .liteTemplateLibrary_template-preview"
        },
        events: {
            "click @ui.previewButton": "onPreviewButtonClick"
        },
        behaviors: {
            insertTemplate: {
                behaviorClass: $app.Behaviors.InsertTemplate
            }
        },
        onPreviewButtonClick: function() {
            $i.library.showPreviewView(this.model)
        }
    }), 
    $app.Modal = elementorModules.common.views.modal.Layout.extend({
        getModalOptions: function() {
            return {
                id: "liteTemplateLibrary_modal",
                hide: {
                    onOutsideClick: !1,
                    onEscKeyPress: !0,
                    onBackgroundClick: !1
                }
            }
        },
        getTemplateActionButton: function(e) {
            var t = e.isPro && !hostimEditor.hasPro ? "pro-button" : "insert-button";
            return viewId = "#hostim-liteTemplateLibrary_" + t, template = Marionette.TemplateCache.get(viewId), Marionette.Renderer.render(template)
        },
        showLogo: function(e) {
            this.getHeaderView().logoArea.show(new $app.Views.Logo(e))
        },
        showDefaultHeader: function() {
            this.showLogo({
                title: "Hostim Templates"
            });
            var e = this.getHeaderView();
            e.tools.show(new $app.Views.Actions), e.menuArea.show(new $app.Views.Menu)
        },
        showPreviewView: function(e) {
            var t = this.getHeaderView();
            t.menuArea.show(new $app.Views.ResponsiveMenu), t.logoArea.show(new $app.Views.BackButton), t.tools.show(new $app.Views.InsertWrapper({
                model: e
            })), this.modalContent.show(new $app.Views.Preview({
                url: e.get("url")
            }))
        },
        showTemplatesView: function(e) {
            this.showDefaultHeader(), this.modalContent.show(new $app.Views.TemplateCollection({
                collection: e
            }))
        }
    }), 

    $app.Manager = function() {
        
        function addButton() {
            var $top = $(this).closest(".elementor-top-section"),
                a = $top.data("id"),
                n = $ele.documents.getCurrent().container.children,
                $sl = $top.prev(".elementor-add-section");
            n && _.each(n, function(e, t) {
                a === e.id && ($this.atIndex = t)
            }), $sl.find(".dl_templates_add_button").length || $sl.find(HOSTIM_FIND_SELECTOR).before($hostimPpenLibraryButton)
        }

        function initAddButton($el) {
            var $t = $el.find(HOSTIM_FIND_SELECTOR);
            $t.length && !$el.find(".dl_templates_add_button").length && $t.before($hostimPpenLibraryButton), $el.on("click.onAddElement", ".elementor-editor-section-settings .elementor-editor-element-add", addButton)
        }

        function onChanges(t, i) {
            i.addClass("elementor-active").siblings().removeClass("elementor-active");
            var a = $dlResponsiveMap[t] || $dlResponsiveMap.desktop;
            $(".liteTemplateLibrary_preview").css("width", a)
        }

        function onEditorLoaded() {
            var $el = window.elementor.$previewContents,
                $t = setInterval(function() {
                    initAddButton($el), $el.find(".elementor-add-new-section").length > 0 && clearInterval($t)
                }, 120);
                $el.on("click.onAddTemplateButton", ".dl_templates_add_button", $this.showModal.bind($this)), this.channels.tabs.on("change:device", onChanges)
        }

        var o, s, d, c, m, $this = this;
        
        HOSTIM_FIND_SELECTOR = ".elementor-add-new-section .elementor-add-section-drag-title", 
        $hostimPpenLibraryButton = '<div class="elementor-add-section-area-button dl_templates_add_button"> <img src="'+hostimEditor.templateLogo+'" /> </div>', 
        $dlResponsiveMap = {
            desktop: "100%",
            tab: "768px",
            mobile: "360px"
        }, 
        this.atIndex = -1, 
        this.channels = {
            tabs: Backbone.Radio.channel("tabs"),
            templates: Backbone.Radio.channel("templates")
        }, 
        this.updateBlocksView = function() {
            $this.setFilter("tags", "", !0), $this.setFilter("text", "", !0), $this.getModal().showTemplatesView(c)
        }, 
        this.setFilter = function(e, t, i) {
            
            $this.channels.templates.reply("filter:" + e, t), i || $this.channels.templates.trigger("filter:change")
        }, 
        this.getFilter = function(e) {
            return $this.channels.templates.request("filter:" + e)
        }, 
        this.getFilterTerms = function() {
            return {
                tags: {
                    callback: function(e) {
                        return _.any(this.get("tags"), function(t) {
                            return t.indexOf(e) >= 0
                        })
                    }
                },
                text: {
                    callback: function(e) {
                        return e = e.toLowerCase(), this.get("title").toLowerCase().indexOf(e) >= 0 || _.any(this.get("type_tags"), function(t) {
                            return i.indexOf(e) >= 0
                        })
                    }
                },
                type: {
                    callback: function(e) {
                        return this.get("type") === e
                    }
                }
            }
        }, 
        this.showModal = function() {
            $this.getModal().showModal(), $this.showTemplatesView()
        }, 
        this.closeModal = function() {
            this.getModal().hideModal()
        }, 
        this.getModal = function() {
            return o || (o = new $app.Modal), o
        }, 
        this.init = function() {
            $this.setFilter("type", hostimEditor.default_tab, !0), $ele.on("preview:loaded", onEditorLoaded.bind(this))
        }, 
        this.getTabs = function() {
            var e = this.getFilter("type");
            return tabs = JSON.parse(hostimEditor.tab_style)
            , _.each(tabs, function(t, i) {
                e === i && (tabs[e].active = !0)
            }), {
                tabs: tabs
            }
        }, 
        this.getTags = function() {
            return s
        }, 
        this.getTypeTags = function() {
            var e = $this.getFilter("type");
            return d[e]
        }, 
        this.showTemplatesView = function() {
            $this.setFilter("tags", "", !0), $this.setFilter("text", "", !0), c ? $this.getModal().showTemplatesView(c) : $this.loadTemplates(function() {
                $this.getModal().showTemplatesView(c)
            })
        }, 
        this.showPreviewView = function(e) {
            $this.getModal().showPreviewView(e)
        }, 
        this.loadTemplates = function(e) {
            $this.requestLibraryData({
                onBeforeUpdate: $this.getModal().showLoadingView.bind($this.getModal()),
                onUpdate: function() {
                    $this.getModal().hideLoadingView(), e && e()
                }
            })
        }, 
        this.requestLibraryData = function(e) {
            if (c && !e.forceUpdate) return void(e.onUpdate && e.onUpdate());
            e.onBeforeUpdate && e.onBeforeUpdate();
            var t = {
                data: {},
                success: function($t) {
                    c = new $app.Collections.Template($t.templates), $t.tags && (s = $t.tags), $t.type_tags && (d = $t.type_tags), e.onUpdate && e.onUpdate()
                }
            };
            e.forceSync && (t.data.sync = !0), elementorCommon.ajax.addRequest("get_hostim_library_data", t)
        }, 
        this.requestTemplateData = function(e, t) {
            var i = {
                unique_id: e,
                data: {
                    edit_mode: !0,
                    display: !0,
                    template_id: e
                }
            };
            t && jQuery.extend(!0, i, t), elementorCommon.ajax.addRequest("get_hostim_template_data", i)
        }, 
        this.insertTemplate = function(e) {
            var t = e.model,
                i = this;
            i.getModal().showLoadingView(), i.requestTemplateData(t.get("template_id"), {
                success: function (e) {
                    
                    i.getModal().hideLoadingView(), i.getModal().hideModal();
                    var a = {}; - 1 !== i.atIndex && (a.at = i.atIndex), $e.run("document/elements/import", {
                        model: t,
                        data: e,
                        options: a
                    }), i.atIndex = -1
                },
                error: function(e) {
                    i.showErrorDialog(e)
                    console.log(i);
                },
                complete: function(e) {
                    i.getModal().hideLoadingView(), window.elementor.$previewContents.find(".elementor-add-section .elementor-add-section-close").click()
                }
            })
        }, 
        this.showErrorDialog = function(e) {
            if ("object" == typeof e) {
                var t = "";
                _.each(e, function(e) {
                    t += "<div>" + e.message + ".</div>"
                }), e = t
            } else e ? e += "." : e = "<i>&#60;The error message is empty&#62;</i>";
            $this.getErrorDialog().setMessage('The following error(s) occurred while processing the request:<div id="elementor-template-library-error-info">' + e + "</div>").show()
        }, 
        this.getErrorDialog = function() {
            return m || (m = elementorCommon.dialogsManager.createWidget("alert", {
                id: "elementor-template-library-error-dialog",
                headerMessage: "An error occurred"
            })), m
        }
    }, 
    $i.library = new $app.Manager,
    $i.library.init(), 
    window.hostim = $i

}(jQuery, window.elementor, window.hostim || {});
