<?php
// Render wraper
$author_name  = hostim_option('blog_list_meta_author', true );
$post_date	  = hostim_option('blog_list_meta_date', true );
$post_comment = hostim_option('blog_list_meta_comments', true );
$word_count   = hostim_option('word_count', '45');
$no_thumb     = has_post_thumbnail() ? 'position-absolute' : 'no_thumb';
$video_post   = has_post_format( 'video' ) ? 'video_post' : '';
$thumb_size   = (isset($sidebar['content']) && !empty($sidebar['content']) ) ? 'hostim_blog_848x440' : 'full';
 ?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'col-md-12' ); ?>>
	<div class="hm2-blog-card bg-white <?php echo esc_attr( $video_post ) ?>">
		<?php 
		if( has_post_thumbnail() ){ ?>
			<div class="feature-img rounded-top overflow-hidden">	
				<a href="<?php the_permalink() ?>">
					<?php the_post_thumbnail( $thumb_size, array('class'=>'img-fluid') )?>
				</a>
			</div>
			<?php 
		} ?>
		<div class="hm2-blog-card-content position-relative">
			
			<?php Hostim_Theme_Helper::hostim_entry_cat( 'category', 'tag-btn rounded-pill '.$no_thumb  ); ?>

			<a href="<?php the_permalink() ?>">
				<h3 class="h3 mb-3 blog_post_title">
					<?php
					if( !empty( get_the_title() ) ){
						the_title();
					}
					else{
						echo __( 'No title', 'hostim' );
					} ?>
				</h3>
			</a>
			<?php echo wpautop( Hostim_Theme_Helper::hostim_substring( get_the_content(), $word_count, '...' ) ); ?>
			<hr class="spacer mt-20 mb-20">
			<div class="bog-author d-flex align-items-center">
				<?php 
				if( $author_name == '1' ){ 
					echo '<span class="post_meta_author">';
					Hostim_Theme_Helper::hostim_posted_author_avatar();
					echo '</span>';
				}
				
				if( $post_date == '1' ){
					echo '<span class="post_meta_date"><i class="far fa-calendar"></i>';
					echo Hostim_Theme_Helper::hostim_archive_url();
					echo '</span>';
				}
				
				if( $post_comment == '1' ){
					echo '<span class="post_meta_comment"><i class="far fa-comment"></i>';
					Hostim_Theme_Helper::hostim_entry_comments(get_the_ID());
					echo '</span>';
				} ?>
			</div>
		</div>
	</div>
</div>